package ai.guiji.duix.cloud.display.ui.dialog

import ai.guiji.duix.cloud.display.R
import ai.guiji.duix.cloud.display.databinding.DialogTextInputBinding
import android.annotation.SuppressLint
import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.ViewGroup
import android.view.Window
import android.widget.Toast

class TextInputDialog(
    private val mContext: Context,
    private var listener: ClickListener?,
    private val cancel: Boolean = true
) : Dialog(mContext, R.style.dialog_center) {

    private var binding: DialogTextInputBinding

    init {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        binding = DialogTextInputBinding.inflate(layoutInflater)
        setContentView(binding.root)
    }

    @SuppressLint("SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.let {
//            it.setGravity(Gravity.BOTTOM)
//            it.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            it.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        }

        binding.btnSend.setOnClickListener {
            val text = binding.etText.text.toString()
            if (!TextUtils.isEmpty(text)){
                listener?.onResult(text)
                dismiss()
            } else {
                Toast.makeText(mContext, "Please input wav url",Toast.LENGTH_SHORT).show()
            }
        }
        setCancelable(cancel)
        setCanceledOnTouchOutside(cancel)
    }

    interface ClickListener {

        fun onResult(text: String)
    }

}