package ai.guiji.duix.cloud.display.ui.dialog

import ai.guiji.duix.cloud.display.R
import ai.guiji.duix.cloud.display.databinding.DialogDriveModeBinding
import android.annotation.SuppressLint
import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.ViewGroup
import android.view.Window

class DriveModeDialog(
    private val mContext: Context,
    private var listener: ClickListener?,
    private val cancel: Boolean = true
) : Dialog(mContext, R.style.dialog_center) {

    private var binding: DialogDriveModeBinding

    companion object{
        const val MODE_MICROPHONE = 0
        const val MODE_AUDIO = 1
        const val MODE_TEXT = 2
        const val MODE_TEXT_QA = 3
    }

    init {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        binding = DialogDriveModeBinding.inflate(layoutInflater)
        setContentView(binding.root)
    }

    @SuppressLint("SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.let {
//            it.setGravity(Gravity.BOTTOM)
//            it.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            it.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        }

        binding.tvMicrophoneDrive.setOnClickListener {
            listener?.onClick(MODE_MICROPHONE)
            dismiss()
        }
        binding.tvAudioDrive.setOnClickListener {
            listener?.onClick(MODE_AUDIO)
            dismiss()
        }
        binding.tvTextDrive.setOnClickListener {
            listener?.onClick(MODE_TEXT)
            dismiss()
        }
        binding.tvTextQADrive.setOnClickListener {
            listener?.onClick(MODE_TEXT_QA)
            dismiss()
        }
        setCancelable(cancel)
        setCanceledOnTouchOutside(cancel)
    }

    interface ClickListener {

        fun onClick(mode: Int)
    }

}