package ai.guiji.duix.cloud.display.ui.activity

import ai.guiji.duix.cloud.display.databinding.ActivityMainBinding
import ai.guiji.duix.sdk.cloud.BuildConfig
import android.Manifest
import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.widget.Toast


class MainActivity : BaseActivity() {

    private lateinit var binding: ActivityMainBinding

    @SuppressLint("SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.tvSdkVersion.text = "SDK Version: ${BuildConfig.VERSION_NAME}"

        binding.btnPlay.setOnClickListener {
            requestPermission(arrayOf(Manifest.permission.RECORD_AUDIO, Manifest.permission.CAMERA), 1)
        }

    }


    override fun permissionsGet(get: Boolean, code: Int) {
        super.permissionsGet(get, code)
        if (get){
            val appId = binding.etAppId.text.toString()
            val appSecret = binding.etAppSecret.text.toString()
            val conversationId = binding.etConversationId.text.toString()
            if (TextUtils.isEmpty(appId)){
                Toast.makeText(mContext, "please enter appId", Toast.LENGTH_SHORT).show()
                return
            }
            if (TextUtils.isEmpty(appSecret)){
                Toast.makeText(mContext, "please enter appSecret", Toast.LENGTH_SHORT).show()
                return
            }
            if (TextUtils.isEmpty(conversationId)){
                Toast.makeText(mContext, "please enter conversationId", Toast.LENGTH_SHORT).show()
                return
            }
            val intent = Intent(mContext, DisplayActivity::class.java)
            intent.putExtra("appId", appId)
            intent.putExtra("appSecret", appSecret)
            intent.putExtra("conversationId", conversationId)
            startActivity(intent)
        } else {
            Toast.makeText(mContext, "Authorization is required to use the function", Toast.LENGTH_SHORT).show()
        }
    }
}
