//
//  DigitalConfig.h
//  GJDigitalSDK
//
//  Created by ah on 2021/11/1.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// Error code enumeration
typedef NS_ENUM(NSInteger, ErrorCode) {
    IM_CONNECT_ERROR,              // Signaling controller connection error, please check network connection status
    IM_LOGIN_ERROR,                // Signaling controller authentication failed
    IM_CONNECTION_CLOSED_ERROR,    // Signaling controller connection has been closed, unable to send signaling
    IM_RTC_REMOTE_SDP_FAILED,      // Failed to set remote SDP
    IM_RTC_LOCAL_SDP_FAILED,       // Failed to set local SDP
};


@interface DigitalConfig : NSObject

/**
 * 打开麦克风(默认YES)
 */
@property (nonatomic, assign) BOOL isOpenMicrophone;

/**
 * openAsr 是否打开asr识别，默认YES
 */
@property (nonatomic, assign) BOOL openAsr;

/**
 * 最小速率， 默认 2000
 */
@property (nonatomic, strong) NSString *minBitrate;

/**
 * 最大速率，, 默认 4000
 */
@property (nonatomic, strong) NSString *maxBitrate;

/**
 * 重试间隔时间, 默认 0
 */
@property (nonatomic, assign) NSInteger timeToReconnected;

/**
 * 连接超时时间, 默认 60000
 */
@property (nonatomic, assign) NSInteger timeToConnected;

/**
 * 0: 远程音视频, 1: 仅启动远程音频
 */
@property (nonatomic, assign) NSInteger rtc_audio_type;

/**
 * 是否远程录屏, 默认 NO
 */
@property (nonatomic, assign) BOOL enableRec;

/**
 * One-shot recognition (not using audio/video): no, long link recognition: yes, default no
 */
@property (nonatomic, assign) BOOL isAsr;

/**
 * 是否启动麦本地克风  (默认 YES)
 */
@property (nonatomic, assign) BOOL isShowLocalAudio;

/**
 * 是否显示本地视频  (默认 NO)
 */
@property (nonatomic, assign) BOOL isShowLocalVideo;

/**
 * 是否打开本地摄像头  (默认 NO)
 */
@property (nonatomic, assign) BOOL isOpenCamera;

/**
 * 关闭会话是是否关闭摄像头  (默认 YES)
 */
@property (nonatomic, assign) BOOL isStopCamera;

/**
 *前置或后置摄像头, 默认YES 表示前置摄像头
 */
@property (nonatomic, assign) BOOL usingFrontCamera;

/**
 * 数字人配置
 */
@property (nonatomic, strong) NSDictionary *humanConfig;

/**
 * 会话ID
 */
@property (nonatomic, strong) NSString *sessionId;

/**
 * 用户ID  (for troubleshooting)
 */
@property (nonatomic, strong) NSString *userId;

/**
 * app名称  (for troubleshooting)
 */
@property (nonatomic, strong) NSString *appName;

/**
 * 扩展字段
 */
@property (nonatomic, strong) NSDictionary *extContext;

/**
 * 是否支持直播模式， 默认 NO
 */
@property (nonatomic, assign) BOOL isLive;

/**
 * Nation 0 中国, 1 海外, 从 Resources.bundle 配置
 */
@property (nonatomic, assign) NSInteger nation;

/**
 * 默认域名, 从 Resources.bundle 配置
 */
@property (nonatomic, strong) NSString *baseUrl;

/**
 * 默认540
 */
@property (nonatomic, assign)NSInteger cameara_width;

/**
 * 默认960
 */
@property (nonatomic, assign)NSInteger cameara_height;


/**
 * 默认25
 */
@property (nonatomic, assign)NSInteger cameara_fps;

/**
 * 是否支持多模态 0否 1是 默认取后台配置参数 ，手动设置initWithAppId之后设置生效
 */
@property (nonatomic, assign)NSInteger multimodal;


/**
 * 情绪识别
 */
@property (nonatomic, assign)NSInteger emotionEnable;


/**
 * (value = "模特训练的类型 168 256 512")
 */
@property (nonatomic, strong)NSString* imgSize;

/**
 *是否静音不推理
 */
@property (nonatomic, assign)BOOL enableNotInferenceWhenSlienceAudio;

//asr 延迟
@property (nonatomic, assign)NSInteger vadSilenceTime;

//是否启用大模型自动回复
@property (nonatomic, assign)NSInteger enableLLM;







+ (DigitalConfig *)shareConfig;


@end

NS_ASSUME_NONNULL_END
