##Silicon based Duix SDK V1.2.2 file for use
Updated on 4/24, 2025

This article introduces how to use the SAAS DUIX iOS SDK, including installation and download, key interfaces, and code examples.
###Material preparation
GJDigitalSDK.framework、WebRTC.framework
`The configuration of the main domain name is usually done by default in the 'Resources. bundle' and 'config. json' sections of GJDigitalSDK. framework.
###Development environment
Development tool: Xcode

###Quick Start
```
#Pragma mark - Start conversation
- (void)toStart {
    
[[DigitalManager manager] initNewWithAppId:AppId appKey:AppKey conversationId:ConversationId region:@"zh_CN" block:^(BOOL isSuccee, NSString *errorMsg) {
if (isSuccee) {
[[DigitalManager manager] toStart];
} else {
NSLog(@"GJDigitalDemo==errorMsg==%@",errorMsg);
}
}];
}
```

###Call process
```
1. Add GJDigitalSDK. framework and WebRTC. framework to the project file;
2. Authorize microphone permissions;
Before starting the DUIX service, it is necessary to prepare the authorized appId, appKey,conversationId；
4. Initialize digital human rendering, ASR, and dialogue interaction services with init, and start initializing communication;
5. Call the toStart function to start rendering the digital human;
6. Whether to call text driven, audio driven, text Q&A, or interrupt based on one's own needs;
7. Call toStop to end and release the rendering of the digital character.
```

###SDK reference (refer to GJDigitalSDK Demo)

1. Drag and drop the GJDigitalSDK. framework and webrtc files to the project's resource directory:
The following frameworks in Engineering General Frameworks, Libraries, and Embedded Content`
```
GJDigitalSDK.framework 
WebRTC.framework 
```
Change to 'Embed&Sign'```

2. Add recording permission and local network permission to Infoplist file
```
<key>NSLocalNetworkUsageDescription</key>
<string>Obtain local network permissions</string>
<key>NSMicrophoneUsageDescription</key>
<string>Recording permission is required for voice recognition</string>
```

------------------------------------------------------------
####SDK key interfaces
```
/**
*SDK initialization
*
* - Parameters:
*   - appId: appId
*   - appKey: appkey
*- conversionId: Conversation Id
*- Block: callback
*/
- (void)initWithAppId:(NSString *)appId appKey:(NSString *)appKey conversationId:(NSString *)conversationId block:(void (^)(BOOL isSuccee,  NSString *errorMsg))block;

/**
*Start communication
*/
- (void)toStart;

/**
*End communication
*/
- (void)toStop;

/**
*Text driven digital humans
*
* - Parameters:
*- text: Text content
*- Interrupt: Do you want to interrupt the previous sentence
*/
- (void)commandEventWithText:(NSString *)text interrupt:(BOOL)interrupt;

/**
*Audio driven digital human
*
* - Parameters:
*- AudioURL: Audio address
*- Interrupt: Do you want to interrupt the previous sentence
*/
- (void)commandEventWithAudioUrl:(NSString *)audioUrl interrupt:(BOOL)interrupt;

/**
*Text Q&A
*
* - Parameters:
*- text: Text content
*- Interrupt: Do you want to interrupt the previous sentence
*/
- (void)commandAskWithText:(NSString *)text interrupt:(BOOL)interrupt;

/**
*Interrupt the digital person's broadcast
*/
- (void)toBreakDigital;

/**
*Microphone reception
*
*- Parameter isEnabled: YES indicates reception, NO indicates mute
*/
- (void)setMute:(BOOL)isEnabled;

/**
*Digital Person Mute
*
*- Parameter enable: YES indicates mute, NO indicates sound reception
*/
- (void)toSpeakerMute:(BOOL)enable;

```

####SDK Proxy
```
@protocol DigitalViewDelegate <NSObject>

/**
*Load digital human resources
*
* - Parameters:
*- isSuccess: Whether it was successful or not
*- progress: loading progress
*/
- (void)onVideoShow:(BOOL)isSuccess progress:(float)progress;

/**
*Abnormal callback
*
* - Parameters:
*- ErrerCode: Error code
*- ErrrMsg: Error message
*/
- (void)onError:(NSInteger)errorCode errorMsg:(NSString *)errorMsg;

@optional

/**
*ASR begins to recognize
*/
- (void)toWebrtcAsrStart;

/**
*ASR recognition
*
* - Parameters:
*- asrText: Recognized Text
*- isFinnish: Is it over
*/
- (void)toWebrtcAsrText:(NSString *)asrText isFinish:(BOOL)isFinish;

/**
*Start talking
*
*- Parameter dict: Dictionary information for starting to speak
*/
- (void)toSpeakStart:(NSDictionary *)dict;

/**
 * Speak Text
 *
 * - Parameter dict: Dictionary information for speak text
 */
- (void)toSpeakText:(NSDictionary *)dict;

/**
*End speaking
*
*- Parameter dict: End of speech dictionary information
*/
- (void)toSpeakStop:(NSDictionary *)dict;

/**
*The audio version starts speaking
*
*- Parameter dict: Dictionary information for starting to speak
*/
- (void)toTTSSpeakStart:(NSDictionary *)dict;

/**
*Audio version ends speaking
*
*- Parameter dict: End of speech dictionary information
*/
- (void)toTTSSpeakStop:(NSDictionary *)dict;

/**
*Central control ends call, sends bye event
*/
- (void)onByeBye;

/**
*Remote video communication completed
*/
- (void)onRTCReomteSuccess;

/**
*Did the audio load successfully
*
*- Parameter isSuccess: Success or not
*/
- (void)onAudioShow:(BOOL)isSuccess;

/**
*WebRTC connection status callback
*
* - Parameter state: RTCIceConnectionState
*/
- (void)didIceConnectionChange:(RTCIceConnectionState)state;

/**
*After obtaining the rendering information, the central control notifies the client
*
* - Parameters:
*   - ID: id
*   - name: name
*/
- (void)onRender:(NSString *)ID name:(NSString *)name;

/**
*Obtain the video stream of local videos
*
* - Parameters:
*   - capturer: capturer
*- frame: video frame
*/
- (void)capturer:(RTCVideoCapturer *)capturer didCaptureVideoFrame:(RTCVideoFrame *)frame;

/**
*Obtain remote audio stream
*
* - Parameter sampleBuffer: Buffer
*/
- (void)onRemoteAudioBuffer:(CMSampleBufferRef)sampleBuffer;

@end
```
------------------------------------------------------------
####Module Usage Code Sample
Detailed demo final code,:
```
///Set custom View
[DigitalManager manager].remote_view = self.customView;

#Pragma mark SDK initialization
[[GJAccess manager] getCamerapermissions:^(bool isPermis) {
if (isPermis)  {
[[DigitalManager manager] initWithAppId:AppId appKey:AppKey conversationId:ConversationId block:^(BOOL isSuccee, NSString *errorMsg) {
if (isSuccee) {
[[DigitalManager manager] toStart];
} else {
NSLog(@"GJDigitalDemo==errorMsg==%@",errorMsg);
}
}];
}
}];

#Pragma mark - End session
- (void)toStop {
    
self.digitalShow = NO;
[[DigitalManager manager] toStop];
}

#Pragma mark SDK agent DigitalViewDelegate
#Pragma mark - Display whether the video has been loaded completely
- (void)onVideoShow:(BOOL)isSuccess progress:(float)progress {
if (isSuccess) {
self.digitalShow = YES;
NSLog (@ "GJDigitalDemo==loading completed");
} else {
NSLog (@ "GJDigitalDemo==loading -% lf", progress);
}
}

#Pragma mark - Abnormal scenario error message
- (void)onError:(NSInteger)error_code errorMsg:(NSString *)errorMsg {
    
if (error_code == -1 || error_code == -2) {
//MQTT connection exception
} else if (error_code == 50001) {
//Wrong or empty appId
} else if (error_code == 50002) {
//Resource check failed, please contact the administrator
} else if (error_code == 50003) {
//Resource usage, please check and try again~
} else if (error_code == 50004) {
//Human request timeout~
} else if (error_code == 50005) {
//Abnormal retrieval of resources from the resource group
} else if (error_code == 50006) {
//Signature failed
} else if (error_code == 50007) {
//Total concurrency of resources is insufficient, please check and try again~
}  else if (error_code == 50009) {
//Resource timeout or not configured~
}
NSLog(@"GJDigitalDemo==errorMsg==%@",errorMsg);
}

```

####Common errors
|Error code | Description|
| ------ | --------------------------------------------------------- |
|-1 | MQTT connection exception|
|-2 | The client interface requests an HTTP status code exception|
|-3 | Client obtains DUIX resources abnormally|
|-4 | Client MQTT connection failed|
|-5 | Client WebRTC SDP creation failed, usually due to iceServer exception|
|-6 | Client WebRTC SDP setting failed, usually due to iceServer exception|
|-7 | Abnormal client session interaction, common examples include authentication failure, ASR resource startup failure, etc|
|1005 | Server token cannot be empty|
|1006 | Server token failure|
|1007 | Server script information does not exist|
|1009 | Insufficient number of available server users|
|2002 | Server session information does not exist|
|40001 | Invalid server appid or appscrect|
|40002 | Internal server error|
|50001 | Incorrect or empty appId|
|50002 | Resource check failed, please contact the administrator|
|50003 | Resource usage, please check and try again~|
|50004 | Human request timeout~|
|50005 | Abnormal retrieval of resources from resource group|
|50006 | Signature failed|
|50007 | Total concurrency of resources is insufficient, please check and try again~|
|50009 | Resource timeout or not configured~|



