//
//  GJAccess.m
//  GJDigitalDuix
//
//  Created by ah on 2021/8/4.
//

#import "GJAccess.h"
#import <AVFoundation/AVFoundation.h>
#import <Photos/Photos.h>
@implementation GJAccess

#pragma mark -
#pragma mark 单实例模式、初始化
+ (GJAccess*)manager {
    static dispatch_once_t once;
    static GJAccess *instance;
    dispatch_once(&once, ^{
        instance = [GJAccess new];
    });
    return instance;
}

- (BOOL)getCamerapermissions {
    
    return isCamera;
}

- (BOOL)getmicrophoneaccess {
    
    return isRecord;
}

- (BOOL)getPhotopermissions {
    
    return isPhoto;
}

//相机权限
- (void)getCamerapermissions:(void (^)(bool isPermis))success {
    
    [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {
        if(granted){
            
        } else {
            NSLog(@"您还没有允许相机权限,录制视频需要相机权限");
        }
        self->isCamera=granted;
        success(granted);
    }];
}

- (void)getmicrophoneaccess:(void (^)(bool isPermis))success {
    __block BOOL ranted;
    [AVCaptureDevice requestAccessForMediaType:AVMediaTypeAudio completionHandler:^(BOOL granted) {
        ranted=granted;
        self->isRecord=granted;
        if (ranted==NO) {
//            [self jumptoVC:ANLocalizedString(@"您还没有允许麦克风权限,录音和语音识别需要麦克风权限", nil)];
        }
        success(ranted);
    }];
}

- (void)getPhotopermissions:(void (^)(bool isPermis))success {
    __block  bool sranted = NO;
    [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
        if (status == PHAuthorizationStatusAuthorized) {
            sranted = YES;
        } else if (status == PHAuthorizationStatusDenied){
            sranted = NO;
            NSLog(@"您还没有允许相册权限");
        } else if (status == PHAuthorizationStatusRestricted) {
            sranted = YES;
        } else {
            sranted=YES;
        }
        self->isPhoto=sranted;
        success(sranted);
    }];
}


@end
